<?php

namespace RachidLaasri\LaravelInstaller\Controllers;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Artisan;
use RachidLaasri\LaravelInstaller\Helpers\DatabaseManager;
use RachidLaasri\LaravelInstaller\Helpers\InstalledFileManager;

class UpdateController extends Controller
{
    use \RachidLaasri\LaravelInstaller\Helpers\MigrationsHelper;

    /**
     * Display the updater welcome page.
     *
     * @return \Illuminate\View\View
     */
    public function welcome($version)
    {
        return view('vendor.installer.update.welcome',["version" => $version]);
    }

    /**
     * Display the updater overview page.
     *
     * @return \Illuminate\View\View
     */
    public function overview($version)
    {
        $migrations = $this->getMigrations($version);
        //$dbMigrations = $this->getExecutedMigrations();
        $seeders = glob(database_path().DIRECTORY_SEPARATOR.'seeds'.DIRECTORY_SEPARATOR.'*.php');
        // dd($seeders);
        return view('vendor.installer.update.overview', ['numberOfUpdatesPending' => count($migrations) + count($seeders),"version"=>$version]);
    }

    /**
     * Migrate and seed the database.
     *
     * @return \Illuminate\View\View
     */
    public function database($version)
    {
        $databaseManager = new DatabaseManager;
        $response = $databaseManager->migrateAndSeed($version);
        return redirect()->route('LaravelUpdater::final')
                         ->with(['message' => $response]);
    }

    /**
     * Update installed file and display finished view.
     *
     * @param InstalledFileManager $fileManager
     * @return \Illuminate\View\View
     */
    public function finish(InstalledFileManager $fileManager)
    {
        $fileManager->update();

        try{
            Artisan::call('cache:forget', ['key' => 'spatie.permission.cache']);
            Artisan::call('cache:clear');
            Artisan::call('config:clear');
            Artisan::call('view:clear');
            Artisan::call('route:clear');
        }catch (\Exception $e){

        }

        return view('vendor.installer.update.finished');
    }
}
